import path_setting
from in_common.base_request import BaseRequest


class im_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.CONVERSATION_DETAIL_CONFIG)

    def conversation_detail(self, current_city_id, begin_msg_id, conversation_type, end_msg_id,referrer):
        #咨询师聊天详情页
        self.params["current_city_id"] = current_city_id
        self.params["begin_msg_id"] = begin_msg_id
        self.params["conversation_type"] = conversation_type
        self.params["end_msg_id"] = end_msg_id
        self.params["referrer"] = referrer
        return self.api_send(self.data["conversation_detail"])
        #该接口已下线

    def auto_msg(self, trace_id, conversation_id):
        self.params["trace_id"] = trace_id
        self.params["conversation_id"] = conversation_id
        return self.api_send(self.data["auto_msg"])

    def send_msg(self, conversation_id, is_system, referrer, referrer_id, msg_type, content, extra):
        #给咨询师发送消息
        self.params["conversation_id"] = conversation_id
        self.params["is_system"] = is_system
        self.params["referrer"] = referrer
        self.params["referrer_id"] = referrer_id
        self.params["msg_type"] = msg_type
        self.params["content"] = content
        self.params["extra"] = extra
        return self.api_send(self.data["send_msg"])
        # 该接口已下线

    def robot_get_second(self, page_type):
        " 获取页面触发私信时间 "
        self.params["page_type"] = page_type
        return self.api_send(self.data["robot_get_second"])

    def robot_send_msg(self, hospital_id, is_system, page_type, req_source, target_user_id, version):
        #给用户发私信
        self.params["hospital_id"] = hospital_id
        self.params["is_system"] = is_system
        self.params["page_type"] = page_type
        self.params["req_source"] = req_source
        self.params["target_user_id"] = target_user_id
        self.params["version"] = version
        return self.api_send(self.data["robot_send_msg"])


if __name__ == '__main__':
    #print(im_request().conversation_detail("beijing", 0, 4, 0,  "message_home"))
    print(im_request().auto_msg("2021/04/22/1722/70a1791606d5",368))
    #print("send_msg")
    #print(im_request().send_msg("368", 0, "message_home", "", 0, "您好，我想咨询一下", {}))
    print(im_request().robot_get_second("3"))
    print(im_request().robot_send_msg("715368769fea4a1ba0c85979112ed154", 1, "3", "gengmei", 33909952, "7.46.0"))




