import path_setting
from in_common.base_request import BaseRequest


class oneimage_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.ONEIMAGE_SHARE_V4_CONFIG)

    # 测颜值结果页
    def share_v4(self,version,face_id):
        self.params["version"] = version
        self.params["face_id"] = face_id

        return self.api_send(self.data["share_v4"])

    # 测颜值结果页，根据五官推荐美购接口
    def recomend_services(self,version,business_tags_names):
        self.params["version"] = version
        self.params["business_tags_names"] = business_tags_names

        return self.api_send(self.data["recomend_services"])



if __name__ == '__main__':
    print(oneimage_request().share_v4("7.42.2",  "27320150"))
    business_tags_names = '[[],[],["玻尿酸垫下巴","自体脂肪垫下巴","硅胶垫下巴","膨体垫下巴"],["半永久纹眉","植眉"],["玻尿酸丰唇","胶原蛋白填充丰唇","自体脂肪丰唇"],[],["开内眼角"],["射频提升","热拉提","热拉提plus","热玛吉","超声提升"],["热玛吉"],[],["注射瘦脸","激光溶脂瘦脸","取颊脂垫瘦脸","光纤溶脂瘦脸","下颌角整形"]]'
    print(oneimage_request().recomend_services("7.42.2", business_tags_names))