import path_setting
from in_common.base_request import BaseRequest

class pay_request(BaseRequest):
    def __init__(self):
        self.wechat_pay = self.api_load(path_setting.WECHAT_PAY)

    def wechat_prepay(self, settlement_id):
        self.params["settlement_id"] = settlement_id
        return self.api_send(self.wechat_pay["wechat_prepay"])

    def alipay_prepay(self, settlement_id, version,is_huabei,huabei_period):
        self.params["settlement_id"] = settlement_id
        self.params["version"] = version
        self.params["is_huabei"] = is_huabei
        self.params["huabei_period"] = huabei_period
        return self.api_send(self.wechat_pay["alipay_prepay"])

    def jump(self,settlement_id):
        self.params["settlement_id"] = settlement_id
        return self.api_send(self.wechat_pay["jump"])


if __name__ == '__main__':
    # print(settlement_request().preview_v1("beijing", "599428", 1, 1, 1, "true", 0))
    print(pay_request().wechat_prepay(522139664651))