import path_setting
from in_common.base_request import BaseRequest


class rank_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.RANK_REQUEST_CONFIG)

    #更美榜单-机构榜
    def rank_hospital(self, city_id, version, device_id= '8C3EB981-B22D-43E2-B208-34F6036505BB'):
        self.params["city_id"] = city_id
        self.params["version"] = version
        return self.api_send(self.data["rank_hospital"])

    #更美榜单-医生榜
    def rank_doctor(self, city_id, version):
        self.params["city_id"] = city_id
        self.params["version"] = version
        return self.api_send(self.data["rank_doctor"])

if __name__ == '__main__':
    print(rank_request().rank_hospital("beijing", "748.0"))


