import path_setting
from in_common.base_request import BaseRequest


class shopcart_request(BaseRequest):

    def __init__(self):
        self.data = self.api_load(path_setting.SHOPCART_CONFIG)

    #购物车列表
    def list(self):
        return self.api_send(self.data["list"])

    #商祥页-加入购物车
    def add(self, from_live, number, service_item_id):
        self.params["from_live"] = from_live
        self.params["number"] = number
        self.params["service_item_id"] = service_item_id
        return self.api_send(self.data["add"])


if __name__ == '__main__':
    #打印购物车列表接口返回
    print(shopcart_request().list())
    #打印商祥页-加入购物车接口返回
    print(shopcart_request().add("", 1, "618788"))