import path_setting
from in_common.base_request import BaseRequest


class web3_request(BaseRequest):
    def __init__(self):
        self.CONVERSATION_ROBOT = self.api_load(path_setting.CONVERSATION_ROBOT)

    def conversation_robot_get_page(self):
        #获取页面类型
        return self.api_send(self.CONVERSATION_ROBOT["conversation_robot_get_page"])

    def conversation_robot_add_message(self, message, csrfmiddlewaretoken):
        #添加私信机器人配置
        self.params["message"] = message
        self.params["csrfmiddlewaretoken"] = csrfmiddlewaretoken
        return self.api_send(self.CONVERSATION_ROBOT["conversation_robot_add_message"])


if __name__ == '__main__':
    print(web3_request().conversation_robot_get_page())
    print(web3_request().conversation_robot_add_message('{"default":[{"name":"","page_type":"0","tag_id":"","tag_name":"","doctor_user_id":602329,"msg_list":[{"id":168,"type":"0","content":"测试"}]}],"personality":[]}', "qzDd1CYV1LngDvQaGjgq4gKoHOPyieHk"))
