import path_setting
from in_common.base_request import BaseRequest

class achelous_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.ACHELOUS_REQUEST_CONFIG)
#直播间批量添加商品
    def batch_add_service(self, stream_id, service_item_ids):
        self.params["stream_id"] = stream_id
        self.params["service_item_ids"] = service_item_ids
        return self.api_send(self.data["batch_add_service"])

    #def batch_del_service(self, stream_id, service_item_ids):
    #    self.params["stream_id"] = stream_id
    #    self.params["service_item_ids"] = service_item_ids
    #    return self.api_send(self.data["batch_add_service"])

    #OM后台-自定义专题搜索
    def special_list(self, page_index, page_capacity, page_id, name, creator_name, create_time_gt, create_time_lt, is_online, status, start_time, end_time):
        self.params["page_index"] = page_index
        self.params["page_capacity"] = page_capacity
        self.params["page_id"] = page_id
        self.params["name"] = name
        self.params["creator_name"] = creator_name
        self.params["create_time_gt"] = create_time_gt
        self.params["create_time_lt"] = create_time_lt
        self.params["is_online"] = is_online
        self.params["status"] = status
        self.params["start_time"] = start_time
        self.params["end_time"] = end_time

        return self.api_send(self.data["special_list"])

    #OM后台-自定义专题创建
    def special_edit(self, user_id, name, id, start_time, end_time, is_online, share_title, share_content, share_pic ):
        self.params["user_id"] = user_id
        self.params["name"] = name
        self.params["id"] = id
        self.params["start_time"] = start_time
        self.params["end_time"] = end_time
        self.params["is_online"] = is_online
        self.params["share_title"] = share_title
        self.params["share_content"] = share_content
        self.params["share_pic"] = share_pic

        return self.api_send(self.data["special_edit"])

    #OM后台-自定义专题删除
    def special_delete(self, ids ):
        self.params["ids"] = ids
        print('*'*100)
        return self.api_send(self.data["special_delete"])

    #OM后台-组件库创建保存/更新保存
    def page_edit(self, visualpage_id, name, visual_info):
        self.params["visualpage_id"] = visualpage_id
        self.params["name"] = name
        self.params["visual_info"] = visual_info
        return self.api_send(self.data["page_edit"])

    #OM后台-自定义专题组件创建保存/更新保存
    def unit_update(self, page_id, order, unit):
        self.params["page_id"] = page_id
        self.params["order"] = order
        self.params["unit"] = unit
        return self.api_send(self.data["unit_update"])



    # OM后台-商业分类管理，后台分类(工业)
    def industry_search(self, tag_system_type,tag_id, tag_name, is_online, is_display, is_move, page, size):
        self.params["tag_system_type"] = tag_system_type
        self.params["tag_id"] = tag_id
        self.params["tag_name"] = tag_name
        self.params["is_online"] = is_online
        self.params["is_display"] = is_display
        self.params["is_move"] = is_move
        self.params["page"] = page
        self.params["size"] = size
        return self.api_send(self.data["industry_search"])

    # OM后台-商业分类管理，后台分类(工业)，标签排序
    def category_ordering(self, tag_id, tag_type, tag_system_type, operation_type):
        self.params["tag_id"] = tag_id
        self.params["tag_type"] = tag_type
        self.params["tag_system_type"] = tag_system_type
        self.params["operation_type"] = operation_type
        return self.api_send(self.data["category_ordering"])

    def catalog_add(self, tag_system_type, tag_name, father_tag_id, child_tag_ids, is_online, is_display, is_move):
        self.params["tag_system_type"] = tag_system_type
        self.params["tag_name"] = tag_name
        self.params["father_tag_id"] = father_tag_id
        self.params["child_tag_ids"] = child_tag_ids
        self.params["is_online"] = is_online
        self.params["is_display"] = is_display
        self.params["is_move"] = is_move
        return self.api_send(self.data["catalog_add"])

    def category_export_catalog_datas(self):
        return self.api_send(self.data["category_export_catalog_datas"])



if __name__ == "__main__":
    # print(achelous_request().batch_add_service("4176", "73809,23508,33823"))
   # print(achelous_request().batch_del_service("4176","7312,7311"))
   #  print(achelous_request().special_edit("32244157","自定义专题创建1","0","2021-08-01 00:00:00","2021-09-30 00:00:00","1","自定义专题创建1","自定义专题创建1","https://heras.igengmei.com/4d5eef0a-78dd-43b3-98b7-137d2341f106-1628565831259"))
   # print(achelous_request().special_list('1', '10', '', '', '', '', '', '1', '0', '', ''))
   # print(achelous_request().industry_search(1,"口腔","all","all","all",1,10))
   # print(achelous_request().category_ordering(1002463,1,1,2))
   # print(achelous_request().catalog_add(1, "自动化接口测试添加2", 15510, [], "false", "false", "false"))
   print(achelous_request().category_export_catalog_datas())