import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.account_request import account_request


class TestLoginVfc:
    data = BaseRequest().api_load(path_setting.LOGIN_VFC)
    loginvfc_case, loginvfc_data = get_ids(data, "login_vfc")

    @pytest.mark.parametrize("param",loginvfc_data,ids=loginvfc_case)
    def test_login_vfc(self,param):
        print(param["vfc_code"])
        r = account_request().login_vfc(param["current_city_id"], param["phone_num"], param["vfc_code"])
        if r["error"] == 0:
            assert r["data"]["account_phone"] == param["assert"]
        if r["error"] == 1:
            assert r["message"] == param["assert"]


