import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.diary_request import diary_request


class TestDiaryUpdate:
    data = BaseRequest().api_load(path_setting.DIARY_UPDATE)
    diary_update_case, diary_update_data = get_ids(data, "diary_update")

    @pytest.mark.parametrize("param", diary_update_data, ids=diary_update_case)
    def test_diary_update(self, param):
        r = diary_request().diary_update(param["topic_list"])
        if r["error"] == 1:
            assert r["message"] == param["message"]






