import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestIndexAi:
    data = BaseRequest().api_load(path_setting.FEED_INDEXAI_DATA)
    indexai_case, indexai_data = get_ids(data, "index_ai")

    @pytest.mark.skip("跳过，目前测试环境数据较少")
    @pytest.mark.parametrize("param", indexai_data, ids=indexai_case)
    def test_index_ai(self, param):
        r = feed_request().index_ai(param["tag_names"], param["scan_type"], param["offset"], param["current_city_id"])
        if r["error"] == 0:
            offset = r["data"]["offset"]
            assert offset == 14
            features = r["data"]["features"]
            assert len(features) == 12
            i = 0
            # 目前临时方案，一半商业流量，一半自然流量
            for index in features:
                print(index["card_type"])
                if i%2 == 0: assert index["card_type"] in (0, 19, 9)
                else: assert index["card_type"] == 43
                i += 1


