import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestIndexV9:
    data = BaseRequest().api_load(path_setting.FEED_INDEXV9_DATA)
    indexv9_case, indexv9_data = get_ids(data, "index_v9")

    @pytest.mark.parametrize("param",indexv9_data,ids=indexv9_case)
    def test_index_v9(self,param):
        if param['tabtype'] == "customize_commodity" :
            r = feed_request().index_v9(param["tabtype"],param["version"],param["current_city_id"],param['tab_id'])
            assert r["error"] == 0
            features = r.get("data").get("features",[])
            assert len(features) > param["assert"]
        else:
            r = feed_request().index_v9(param["tabtype"],param["version"],  param["current_city_id"])
            if r["error"] == 0:
                features = r.get("data").get("features",[])
                assert len(features) > param["assert"]





