import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestWinningUserList:
    data = BaseRequest().api_load(path_setting.WINNING_USER_LIST)
    winning_user_list_case, winning_user_list_data = get_ids(data, "winning_user_lis")

    @pytest.mark.parametrize("param", winning_user_list_data, ids=winning_user_list_case)
    def test_winning_user_list_case(self, param):
        r = feed_request().winning_user_lis(param["recruit_id"], param["json"])
        if r["error"] == 0:
            assert r["data"]["users"][0]["id"] != param["assert"]




