import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.filter_request import filter_request


class TestServiceHomeCityV2:
    data = BaseRequest().api_load(path_setting.FILTER)
    service_home_city_v2_case, service_home_city_v2_data = get_ids(data, "service_home_city_v2")

    @pytest.mark.parametrize("param", service_home_city_v2_data, ids=service_home_city_v2_case)
    def test_service_home_city_v2(self, param):
        r = filter_request().service_home_city_v2(param["current_city_id"], param["lat"], param["lng"])

        if param["current_city_id"] == "worldwide":
            assert r["error"] == param["assert_worldwide"]
        if param["lat"] == "39.98316321398558" and param["lng"] == "116.4881236681604":
            assert r["data"]["recommend"]["located"][0]["id"] == param["assert_beijing"]
        if param["lat"] == "45.742347" and param["lng"] == "126.661669":
            assert r["data"]["recommend"]["located"][0]["id"] == param["assert_haerbin"]
