import pytest
from bs4 import BeautifulSoup

import path_setting
from all_backend_api.hybrid_request import hybrid_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#百科详情页-项目聚合百科，玻尿酸
class TestSubWiki:
    data = BaseRequest().api_load(path_setting.SUBWIKI)
    subwiki_case, subwiki_data = get_ids(data, "sub_wiki")

    @pytest.mark.parametrize("param", subwiki_data, ids=subwiki_case)
    def test_sub_wiki(self, param):
        r = hybrid_request().sub_wiki(param["version"], param["current_city_id"])
        soup = BeautifulSoup(r, 'lxml')  # html.parser是解析器，也可是lxml
        assert soup.title.string == param["assert"]
        print('进入项目聚合百科-玻尿酸的百科详情页')