import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.im_request import im_request


class TestRobotGetSecond:
    data = BaseRequest().api_load(path_setting.ROBOT_GET_SECOND)
    robot_get_second_case, robot_get_second_data = get_ids(data, "robot_get_second")

    @pytest.mark.parametrize("param", robot_get_second_data, ids=robot_get_second_case)
    def test_robot_get_second(self, param):
        r = im_request().robot_get_second(param["page_type"])
        print(r)
        if r["error"] == 0:
            assert r["data"]["second"] == param["assert"]

