import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.im_request import im_request


class TestRobotSendMsg:
    data = BaseRequest().api_load(path_setting.ROBOT_SEND_MSG)
    robot_send_msg_case, robot_send_msg_data = get_ids(data, "robot_send_msg")

    @pytest.mark.parametrize("param", robot_send_msg_data, ids=robot_send_msg_case)
    def test_robot_send_msg(self, param):
        r = im_request().robot_send_msg(param["hospital_id"], param["is_system"], param["page_type"], param["req_source"], param["target_user_id"], param["version"])
        print(r)
        assert r["error"] == param["assert"]
        #if r["error"] == 0:
            #assert r["data"]["second"] == param["assert"]

