import pytest

import path_setting
from all_backend_api.janus_request import janus_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestCommodityRank:
    data = BaseRequest().api_load(path_setting.COMMODITY_RANK)
    commodity_rank_case, commodity_rank_data = get_ids(data, "commodity_rank")

    @pytest.mark.parametrize("param", commodity_rank_data, ids=commodity_rank_case)
    def test_commodity_rank(self,param):
        project_rank = janus_request().project_rank("143", "748.0", "beijing")
        param["title"] = project_rank["data"]["project_detail"]["items"][0]["title"]
        param["commodity_rank_id"] = project_rank["data"]["project_detail"]["items"][0]["exposure"]["card_id"]
        r = janus_request().commodity_rank(param["sort_type"], param["commodity_rank_id"], param["version"])
        if r["error"] == 0:
            assert r["data"]["commodity_detail"]["title"] == param["title"]
            print("项目榜单-商品榜单接口已通")
        else:
            assert r["error"] == param["assert_error"]
            print("项目榜单-商品榜单接口出错了")
