import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestProductDetail:
    data = BaseRequest().api_load(path_setting.JANUS_PRODUCT_DETAIL)
    product_detail_case, product_detail_data = get_ids(data, "product_detail")

    @pytest.mark.parametrize("param", product_detail_data, ids=product_detail_case)
    def test_product_detail(self, param):
        r = janus_request().product_detail(param["service_id"], param["service_item_id"], param["version"])

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]
            assert r["data"]["service_hospital"]["services"] != param["assert_service_hospital"]
        if r["error"] == 1:
            assert r["message"] == param["assert_spu_message"]

