import pytest

import path_setting
from all_backend_api.janus_request import janus_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestProjectRank:
    data = BaseRequest().api_load(path_setting.PROJECT_RANK)
    project_rank_case, project_rank_data = get_ids(data, "project_rank")

    @pytest.mark.parametrize("param", project_rank_data, ids=project_rank_case)
    def test_project_rank(self, param):
        r = janus_request().project_rank(param["id"], param["version"], param["current_city_id"])

        if r["error"] == 0:
            assert r["data"]["project_detail"]["title"] == param["assert"]
            print("项目榜单主页接口已通")
        else:
            assert r["error"] == param["assert_error"]
            print("接口出错了")


