import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestServicePromotionRelatedServiceData:
    data = BaseRequest().api_load(path_setting.SERVICE_PROMOTION_RELATED_SERVICE_DATA)
    service_promotion_related_service_data_case, service_promotion_related_service_data_data = \
        get_ids(data, "service_promotion_related_service_data")

    @pytest.mark.parametrize("param", service_promotion_related_service_data_data,
                             ids=service_promotion_related_service_data_case)
    def test_service_promotion_related_service_data_case(self, param):
        r = janus_request().service_promotion_related_service_data(param["service_id"], param["page"],
                                                                   param["current_city_id"])

        if param["page"] == 1:
            assert len(r["data"]["services"]) == param["assert_page1_len"]
        if param["page"] == 2:
            assert len(r["data"]["services"]) == param["assert_page2_len"]
        if r["error"] == 0:
            assert r["data"]["services"][0]["title"] is not None
            assert r["data"]["services"][0]["price_info"] is not None
            assert r["data"]["services"][0]["sell_num_desc"] is not None
            assert r["data"]["services"][0]["doctor_hospital_name"] is not None
            assert r["data"]["services"][0]["distance"] is not None

