import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestSkuInfo:
    data = BaseRequest().api_load(path_setting.JANUS_SKU_INFO)
    sku_info_case, sku_info_data = get_ids(data, "sku_info")

    @pytest.mark.parametrize("param", sku_info_data, ids=sku_info_case)
    def test_sku_info(self, param):
        r = janus_request().sku_info(param["service_id"], param["service_item_id"])

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]

