import pytest

import path_setting
from all_backend_api.janus_live_request import live_request
from all_backend_api.live_request import living_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestAddLiveService:
    data = BaseRequest().api_load(path_setting.ADDLIVESERVICE)
    addliveservice_case, addliveservice_data = get_ids(data, "add_live_service")

    @pytest.mark.parametrize("param", addliveservice_data, ids=addliveservice_case)
    def test_add_live_service(self, param):
        print(111111111111111111111)
        pushlive = living_request().pushlive_info("啊哈", "2021/08/14/1003/cef471cff5e6", "啊哈-公告", "1", "2", "1")
        param["channel_id"] = pushlive["data"]["channel"]
        r = live_request().add_live_service(param["channel_id"], param["service_item_ids"], param["version"])
        if r["error"] == 0:
            assert r["data"]["toast"] == param["assert"]
        else:
            assert r["message"] == param["assert_message"]
            print("接口出错了")
        living_request().finish(param["channel_id"], "747.0")
        living_request().finish(param["channel_id"], "747.0")
        living_request().finish(param["channel_id"], "747.0")