import pytest

import path_setting
from all_backend_api.janus_live_request import live_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestPopGift:
    data = BaseRequest().api_load(path_setting.POP_GIFT)
    pop_gift_case, pop_gift_data = get_ids(data, "pop_gift")

    @pytest.mark.parametrize("param", pop_gift_data, ids=pop_gift_case)

    def test_pop_gift(self,param):
        r = live_request().pop_gift(param["stream_id"], param["gift_id"], param["version"])
        if r["data"] is not None:
            print("成功弹出美券")
            assert r["data"]["gift_id"] == param["assert"]
        else:
            print("出错了！！！")