import pytest

import path_setting
from all_backend_api.pay_request import pay_request
from all_backend_api.settlement_request import settlement_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestJump:
    data = BaseRequest().api_load(path_setting.JUMPDATA)
    jump_case, jump_data = get_ids(data, "jump")

    @pytest.mark.parametrize("param", jump_data, ids=jump_case)
    def test_jump(self, param):
        create_resp = settlement_request().create_v1(param["service_item_id"],param["number"],param["platform_coupon_id"],param["use_point"],
                                       param["is_doctor_see"],param["doctor_coupon_id"],param["insurance_info"],param["is_create_groupbuy"])
        settlement_id = create_resp["data"]["id"]
        r = pay_request().jump(settlement_id)
        print(r)
        assert r["error"] == param["assert"]

