import pytest

import path_setting
from all_backend_api.rank_request import rank_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestRankDoctor:
    data = BaseRequest().api_load(path_setting.RANK_DOCTOR)
    rank_doctor_case, rank_doctor_data = get_ids(data, "rank_doctor")

    @pytest.mark.parametrize("param", rank_doctor_data, ids=rank_doctor_case)
    def test_rank_doctor(self, param):
        r = rank_request().rank_doctor(param["city_id"], param["version"])

        if r["error"] == 0:
            assert r["data"]["data"][0]["hospital"].find(param['assert_city']) != param["assert"]
            print("更美榜单-医生榜接口已通")
        else:
            assert r["data"]["data"][0]["hospital"].find(param["assert_city"]) == param["assert_error"]
            print("更美榜单-医生榜，接口出错了")

