import pytest

import path_setting
from all_backend_api.rank_request import rank_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestRankHospital:
    data = BaseRequest().api_load(path_setting.RANK_HOSPITAL)
    rank_hospital_case, rank_hospital_data = get_ids(data, "rank_hospital")

    @pytest.mark.parametrize("param", rank_hospital_data, ids=rank_hospital_case)
    def test_rank_hospital(self,param):
        r = rank_request().rank_hospital(param["city_id"], param["version"])
        if r["error"] == 0:
            assert r["data"]["data"][0]["name"].find(param["assert_city"]) != param["assert"]
        else:
            assert r["data"]["data"][0]["name"].find(param["assert_city"]) == param["assert_error"]
