import pytest

from all_backend_api.services_request import services_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestV1:
    data = BaseRequest().api_load(path_setting.SERVICES_V1_DATA)
    v1_case, v1_data = get_ids(data, "v1")

    @pytest.mark.parametrize("param", v1_data, ids=v1_case)
    def test_share_data(self, param):
        r = services_request().v1(param["coupon_info_id"], param["order_by"])
        if r["error"] == 0:
            assert len(r["data"]) > 0
            print(r)
