import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.skin_request import skin_request

# 测肤底根据选项获取推荐方案
class TestSkinSchemeCard:
    data = BaseRequest().api_load(path_setting.SKIN_SCHEME_CARD_DATA)
    skin_scheme_card_case, skin_scheme_card_data = get_ids(data, "scheme_card")

    @pytest.mark.parametrize("param", skin_scheme_card_data, ids=skin_scheme_card_case)
    def test_scheme_card(self,param):
        r = skin_request().skin_scheme_card(param["scene_id"], param["target_id"], param["recover_time_id"])
        if r["error"] == 0:
            # 推荐美购卡片下面文案部分
            title = r["data"]["title"]
            content = r["data"]["content"]
            assert title == param["title"]
            assert content == param["content"]

            # 用户选择目标
            scene_name = r["data"]["scene_name"]
            target_name = r["data"]["target_name"]
            recover_time_name = r["data"]["recover_time_name"]
            assert scene_name == param["scene_name"]
            assert target_name == param["target_name"]
            assert recover_time_name == param["recover_time_name"]

            # 推荐美购卡片信息
            original_price = r["data"]["service_card"]["original_price"]
            gengmei_price = r["data"]["service_card"]["gengmei_price"]
            assert original_price not in (None, "")
            assert gengmei_price not in (None, "")


            service_id = r["data"]["service_card"]["service_id"]
            service_name = r["data"]["service_card"]["service_name"]
            assert service_name not in (None, "")
            image_header = r["data"]["service_card"]["image_header"]
            assert image_header not in (None, "")
            # import requests
            # resp = requests.get(url=image_header, verify=False)
            # print(resp.text)
            # # 判断返回是否有报错信息，否则是一张图片
            # assert "errcode" not in resp.text, f'测颜值返回二维码图片不可用'
            gm_url = r["data"]["service_card"]["gm_url"]
            assert gm_url == "gengmei://service?service_id={}&sign_points=20&has_task=0&transparent_key=rm_r63bkpbh_0&sign_task_seconds=10".format(service_id)