import json

import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request


class TestCreate:
    data = BaseRequest().api_load(path_setting.TRACTATE_CREATE)
    create_case, create_data = get_ids(data, "create")

    @pytest.mark.parametrize("param", create_data, ids=create_case)
    def test_create(self, param):
        # 登录了的-校验
        r = tractate_request().create()
        assert r["error"] == param["error1"]
        # 未登录的-校验
        s = tractate_request().create_unlogin()
        s = json.loads(s)
        # r = json.loads(r)
        # print(type(r))
        assert s["message"] == param["message1"]








