import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestBaseSignData:
    data = BaseRequest().api_load(path_setting.SIGN)
    base_sign_data_case, base_sign_data_data = get_ids(data, "base_sign_data")

    @pytest.mark.parametrize("param", base_sign_data_data, ids=base_sign_data_case)
    def test_favors_diaries(self, param):
        r = user_request().base_sign_data()
        assert r["error"] == param["assert"]
        #  校验字段是否存在
        # print(r["data"])
        assert r["data"]["wait_time"] is not None and r["data"]["wait_time"] is not ""   # 是否关注
        assert r["data"]["new_user"] is not None and r["data"]["new_user"] is not ""   # 是否关注
        assert r["data"]["sign_status"] is not None and r["data"]["sign_status"] is not ""   # 是否关注
        assert r["data"]["user_id"] is not None and r["data"]["user_id"] is not ""   # 是否关注
        assert r["data"]["days_to_gift"] is not None and r["data"]["days_to_gift"] is not ""   # 是否关注


# assert r["data"] is True

