import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request

class TestChangePwd:
    data = BaseRequest().api_load(path_setting.CHANGE_PWD)
    change_pwd_case, change_pwd_data = get_ids(data, "change_pwd")

    @pytest.mark.parametrize("param",change_pwd_data, ids=change_pwd_case)
    def test_change_pwd(self, param):
        r = user_request().change_pwd(param["version"], param["change_type"],param["new_password"],param["repeat_password"])
        if r.get("error_code") == 22006:
            assert r["message"] == param["assert"]
        elif r.get("error_code") == -1:
            assert r["message"] == param["assert"]
        elif r.get("error") == 0:
            assert r["error"] == param["assert1"]
