import pytest
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request

class TestChangePwdd:
    data = BaseRequest().api_load(path_setting.CHANGE_PWDD)
    change_pwdd_case, change_pwdd_data = get_ids(data, "change_pwdd")

    @pytest.mark.parametrize("param",change_pwdd_data, ids=change_pwdd_case)
    def test_change_pwdd(self, param):
        r = user_request().change_pwdd(param["version"],param["password"] ,param["change_type"],param["new_password"],param["repeat_password"])
        if r.get("error_code") == 22006:
            assert r["message"] == param["assert"]
        elif r.get("error_code") == -1:
            assert r["message"] == param["assert"]
        elif r.get("error") == 0:
            assert r["error"] == param["assert"]
 #       else:
  #          assert r["message"] == param["assert2"]
