import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestMyQuestion:
    data = BaseRequest().api_load(path_setting.MY_QUESTION)
    my_question_case, my_question_data = get_ids(data, "my_question")

    @pytest.mark.parametrize("param", my_question_data, ids=my_question_case)
    def test_my_question(self, param):
        r = user_request().my_question(param["start_num"], param["count"])

        assert r["error"] == param["assert"]

