import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestSignCalendar:
    data = BaseRequest().api_load(path_setting.SIGN_CALENDAR)
    sign_calendar_case, sign_calendar_data = get_ids(data, "sign_calendar")

    @pytest.mark.parametrize("param", sign_calendar_data, ids=sign_calendar_case)
    def test_favors_diaries(self, param):
        r = user_request().sign_calendar()
        assert r["error"] == param["assert"]
        assert r["data"]["user_id"] is not None and r["data"]["user_id"] is not ""   # 判断用户名是否为空
