import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.verification_code_request import verification_code_request

class TestVerificationCode:
    data = BaseRequest().api_load(path_setting.VERIFICATION_CODE)
    verification_code_case, verification_code_data = get_ids(data, "verification_code")

    @pytest.mark.parametrize("param",verification_code_data, ids=verification_code_case)
    def test_verification_code(self, param):
        r = verification_code_request().verification_code(param["phone"], param["type"], param["verifier"])

        if r["error"] == 0:
            assert r["error"] == param["assert"]
