import pytest

import path_setting
from all_backend_api.visual_beauty_card import visual_beauty_card_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#次卡商品列表组件商品
class TestBeautyCardSkus:
    data = BaseRequest().api_load(path_setting.BEAUTYCARD_SKUS)
    beautycard_skus_case, beautycard_skus_data = get_ids(data, "beautycard_skus")

    @pytest.mark.parametrize("param", beautycard_skus_data, ids=beautycard_skus_case)
    def test_beautycard_skus(self, param):
        r = visual_beauty_card_request().beautycard_skus(param["unit_id"], param["tag_id"], param["area"],
                                                         param["sort_type"], param["page"], param["page_size"],
                                                         param["version"])
        if r["error"] == 0:
            assert len(r["data"]["beautycards"]) > param["assert"]
            assert r["message"] == param["assert_message"]
            assert r["data"]["beautycards"][0]["bc_spu_id"] is not None
            assert r["data"]["beautycards"][0]["bc_spu_name"] is not None
            assert r["data"]["beautycards"][0]["bc_sku_id"] is not None
            assert r["data"]["beautycards"][0]["bc_sku_name"] is not None
            assert r["data"]["beautycards"][0]["bc_image"] is not None
            assert r["data"]["beautycards"][0]["bc_origin_price"] is not None
            assert r["data"]["beautycards"][0]["bc_gengmei_price"] is not None
            assert r["data"]["beautycards"][0]["sales_amount"] is not None
            assert r["data"]["beautycards"][0]["gm_url"] is not None
            assert r["data"]["beautycards"][0]["rank"] is not None
            assert r["data"]["beautycards"][0]["has_discount"] is not None
            assert r["data"]["beautycards"][0]["bc_discount_total_payment"] is not None
        else:
            assert r["message"] == param["assert_message"]
            print('接口出错了')
