import pytest

import path_setting
from all_backend_api.visual_beauty_card import visual_beauty_card_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#次卡橱窗商品
class TestVisualBeautyCardServices:
    data = BaseRequest().api_load(path_setting.VISUAL_BEAUTY_CARD_SERVICES)
    visual_beauty_card_services_case, visual_beauty_card_services_data = get_ids(data, "visual_beauty_card_services")

    @pytest.mark.parametrize("param", visual_beauty_card_services_data, ids=visual_beauty_card_services_case)
    def test_visual_beauty_card_services(self, param):
        r = visual_beauty_card_request().visual_beauty_card_services(param["unit_id"], param["current_city_id"], param["page"], param["page_size"], param["version"])
        if param["unit_id"] == "20105":
            assert len(r["data"]["beautycards"]) > param["assert_spu"]
            assert r["data"]["beautycards"][0]["bc_spu_id"] is not None
            assert r["data"]["beautycards"][0]["bc_spu_name"] is not None
            assert r["data"]["beautycards"][0]["bc_sku_id"] is not None
            assert r["data"]["beautycards"][0]["bc_sku_name"] is not None
            assert r["data"]["beautycards"][0]["bc_image"] is not None
            assert r["data"]["beautycards"][0]["bc_origin_price"] is not None
            assert r["data"]["beautycards"][0]["bc_gengmei_price"] is not None
            assert r["data"]["beautycards"][0]["sales_amount"] is not None
            assert r["data"]["beautycards"][0]["gm_url"] is not None
            assert r["data"]["beautycards"][0]["rank"] is not None
            assert r["data"]["beautycards"][0]["has_discount"] is not None
            assert r["data"]["beautycards"][0]["bc_discount_total_payment"] is not None
        if param["unit_id"] == "20106":
            assert len(r["data"]["beautycards"]) > param["assert_sku"]
            assert r["data"]["beautycards"][0]["bc_spu_id"] is not None
            assert r["data"]["beautycards"][0]["bc_spu_name"] is not None
            assert r["data"]["beautycards"][0]["bc_sku_id"] is not None
            assert r["data"]["beautycards"][0]["bc_sku_name"] is not None
            assert r["data"]["beautycards"][0]["bc_image"] is not None
            assert r["data"]["beautycards"][0]["bc_origin_price"] is not None
            assert r["data"]["beautycards"][0]["bc_gengmei_price"] is not None
            assert r["data"]["beautycards"][0]["sales_amount"] is not None
            assert r["data"]["beautycards"][0]["gm_url"] is not None
            assert r["data"]["beautycards"][0]["rank"] is not None
            assert r["data"]["beautycards"][0]["has_discount"] is not None
            assert r["data"]["beautycards"][0]["bc_discount_total_payment"] is not None