import pytest

import path_setting
from all_backend_api.visual_request import visual_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestServiceList:
    data = BaseRequest().api_load(path_setting.VISUAL_SERVICE_LIST)
    service_list_case, service_list_data = get_ids(data, "service_list")
#
    @pytest.mark.parametrize("param", service_list_data, ids=service_list_case)
    def test_service_list(self, param):
        r = visual_request().service_list(param["unit_id"])
        assert r["error"] == 0
        list = r.get("data").get("services",[])
        assert len(list) == param["len"]

