import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web2_request import web2_request


class TestArtemisCpcCategoryQuery:
    data = BaseRequest().api_load(path_setting.CPCCATEGORYQUERY)
    cpccategoryquery_case, cpccategoryquery_data = get_ids(data, "artemis_cpc_category_query")


    @pytest.mark.parametrize("param",cpccategoryquery_data,ids=cpccategoryquery_case)
    def test_artemis_cpc_category_query(self, param):
        '''点点通商品-品类推广管理-'''
        r = web2_request().artemis_cpc_category_query(param["doctor_id"], param["flag_relation"])
        print(r)
        if r["error"] == 0:
            data = r.get("data", [])
            assert len(data) >= param["assert"]



