import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web2_request import web2_request


class TestArtemisCpcCategoryServiceIds:
    data = BaseRequest().api_load(path_setting.CPCCATEGORYSERVICEIDS)
    cpccategoryserviceids_case, cpccategoryserviceids_data = get_ids(data, "artemis_cpc_category_service_ids")


    @pytest.mark.parametrize("param",cpccategoryserviceids_data,ids=cpccategoryserviceids_case)
    def test_artemis_cpc_category_service_ids(self, param):
        '''点点通商品-品类推广管理-新增品类推广-关联美购'''
        r = web2_request().artemis_cpc_category_service_ids(param["page"], param["pagesize"], param["is_online"], param["category_id"])
        print(r)
        if r["error"] == 0:
            assert r["data"]["services"][0]["is_online"] == param["assert"]






