import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web2_request import web2_request


class TestCpcDoctorPromoteFlows:
    data = BaseRequest().api_load(path_setting.CPCDOCTORPROMOTEFLOWS)
    cpcdoctorpromoteflows_case, cpcdoctorpromoteflows_data = get_ids(data, "cpc_doctor_promote_flows")


    @pytest.mark.parametrize("param",cpcdoctorpromoteflows_data,ids=cpcdoctorpromoteflows_case)
    def test_cpc_doctor_promote_flows(self, param):
        '''点点通商品-历史每月推广明细-导出'''
        r = web2_request().cpc_doctor_promote_flows(param["month"])
        if r["error"] == 0:
            flows_list = r.get("data").get("flows_list", [])
            assert len(flows_list) >= param["assert"]



