import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web3_request import web3_request


class TestConversationRobotAddMessage:
    data = BaseRequest().api_load(path_setting.ROBOTADDMESSAGE)
    robot_add_message_case, robot_add_message_data = get_ids(data, "conversation_robot_add_message")


    @pytest.mark.parametrize("param",robot_add_message_data,ids=robot_add_message_case)
    def test_conversation_robot_add_message(self, param):
        '''私信机器人-添加私信配置'''
        r = web3_request().conversation_robot_add_message(param["message"], param["csrfmiddlewaretoken"])
        if r["error"] == 0:
            assert r["message"] == param["assert"]
