import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web3_request import web3_request


class TestConversationRobotGetPage:
    data = BaseRequest().api_load(path_setting.ROBOTGETPAGE)
    robot_get_page_case, robot_get_page_data = get_ids(data, "conversation_robot_get_page")


    @pytest.mark.parametrize("param",robot_get_page_data,ids=robot_get_page_case)
    def test_conversation_robot_get_page(self, param):
        '''私信机器人-获取页面类型'''
        r = web3_request().conversation_robot_get_page()
        if r["error"] == 0:
            #flows_list = r.get("data").get("flows_list", [])
            assert r["data"]["1"] == param["assert1"]
            assert r["data"]["2"] == param["assert2"]
            assert r["data"]["3"] == param["assert3"]
