import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestCpcPromoteFlows:
    data = BaseRequest().api_load(path_setting.CPCPROMOTEFLOWS)
    cpcpromoteflows_case, cpcpromoteflows_data = get_ids(data, "cpc_promote_flows")


    @pytest.mark.parametrize("param",cpcpromoteflows_data,ids=cpcpromoteflows_case)
    def test_cpc_promote_flows(self, param):
        '''点点通商品-历史每月推广明细'''
        r = web_request().cpc_promote_flows(param["month"])
        if r["error"] == 0:
            flows_list = r.get("data").get("flows_list", [])
            assert len(flows_list) >= param["assert"]


