import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestDoctorDoctorlist:
    data = BaseRequest().api_load(path_setting.DOCTORLIST)
    doctor_doctorlist_case, doctor_doctorlist_data = get_ids(data, "doctor_doctorlist")


    @pytest.mark.parametrize("param",doctor_doctorlist_data,ids=doctor_doctorlist_case)
    def test_doctor_doctorlist(self, param):
        '''医生列表'''
        r = web_request().doctor_doctorlist(param['doctor_type'])
        assert r["error"] == 0
        assert r["data"]['doctors'] is not None and type(r["data"]['doctors']) is list
