import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_doctor_api.web_request import web_request


class TestDoctorVerificationcode:
    data = BaseRequest().api_load(path_setting.DOCTOR_VERIIFICATIONCODE)
    doctor_verificationcode_case, doctor_verificationcode_data = get_ids(data, "doctor_verificationcode")


    @pytest.mark.parametrize("param",doctor_verificationcode_data,ids=doctor_verificationcode_case)
    def test_doctor_verificationcode(self, param):
        '''医生列表'''
        r = web_request().doctor_verificationcode(param['phone'])
        assert r["error"] == 0
        assert r['data']['code'] == param["code"]
        assert r['data']['message'] == param["message"]

