import pytest
import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

class TestBatchAddService:
    data = BaseRequest().api_load(path_setting.BATCH_ADD_SERVICE)
    batch_add_service_case, batch_add_service_data = get_ids(data, "batch_add_service")

    @pytest.mark.parametrize("param",batch_add_service_data,ids=batch_add_service_case)
    def test_batch_add_service(self,param):
        r = achelous_request().batch_add_service(param['stream_id'],param['service_item_ids'])
        #print(type(r["failed_service_item_ids"]))
        if r.get("code") == 1:
            assert r['message'] == param["assert"]
        elif  len(r["failed_service_item_ids"]) == 0:
            assert r["success_service_item_ids"] == param["assert2"]
        elif  r["success_service_item_ids"] == 0:
            assert r["success_service_item_ids"] == param["assert1"]
