import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestCategortAdd:
    data = BaseRequest().api_load(path_setting.ACHELOUS_CATEGORY_ADD_DATA)
    catalog_add_case, catalog_add_data = get_ids(data, 'catalog_add')

    @pytest.mark.parametrize("param", catalog_add_data, ids=catalog_add_case)
    def test_category_add(self, param):

        import datetime
        dt = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')

        r = achelous_request().catalog_add(param["tag_system_type"], param["tag_name"]+dt, param["father_tag_id"], param["child_tag_ids"], param["is_online"], param["is_display"], param["is_move"])
        print(r)

