import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestCategortOrdering:
    data = BaseRequest().api_load(path_setting.ACHELOUS_CATEGORY_ORDERING_DATA)
    category_ordering_case, category_ordering_data = get_ids(data, 'category_ordering')

    @pytest.mark.parametrize("param", category_ordering_data, ids= category_ordering_case)
    def test_category_ordering(self, param):
        r = achelous_request().category_ordering(param["tag_id"], param["tag_type"],param["tag_system_type"], param["operation_type"])
        print(r)
        if r["code"] == 0 and r["msg"] == "success":
            assert len(r["data"]) > 0

