import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestIndustrySearch:
    data = BaseRequest().api_load(path_setting.ACHELOUS_INDUSTRY_SEARCH_DATA)
    industry_search_case, industry_search_data = get_ids(data, 'industry_search')

    @pytest.mark.parametrize("param", industry_search_data, ids= industry_search_case)
    def test_industry_search(self, param):
        r = achelous_request().industry_search(param["tag_system_type"], param["tag_id"],param["tag_name"],param["is_online"], param["is_display"], param["is_move"], param["page"], param["size"])
        print(r)
        assert r["code"] == 0
        assert len(r["data"]["data"]) > 0

